Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 147.51, y = 150.82, z = 14, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["army_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_set", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["check_pass_east"] = 
{
	active = true, 
	effect_radius = 15, 
	position = { y=-62, x=206.6, z=12.9, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_east", 
	type = "quest", 
}

Triggers["check_pass_north"] = 
{
	active = true, 
	effect_radius = 15, 
	position = { y=24.1, x=197.7, z=14.8, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_north", 
	type = "quest", 
}

Triggers["check_pass_south"] = 
{
	active = true, 
	effect_radius = 15, 
	position = { y=-74.9, x=141.5, z=15.2, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_south", 
	type = "quest", 
}

Triggers["check_pass_west"] = 
{
	active = true, 
	effect_radius = 15, 
	position = { y=11.7, x=125.3, z=14, f=1 }, 
	priority = 1, 
	think = "tf_check_pass_west", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["mission"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_mission", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 7, 
	position = { x = 64.1, y = 18.1, z = 12.9, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

Triggers["save_the_shammy"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_save_the_shammy", 
	type = "quest", 
}

trigger_functions =
{
tf_army_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		if ARMY == Sectors.base.owner then
			Triggers["army_set"].active = true
		end	
		if CORP == Sectors.base.owner then
			Triggers["corp_set"].active = true
		end
	end
end,
tf_check_pass_east = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_check_pass_north = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_check_pass_south = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_check_pass_west = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
--		Sectors.base.isEscaped = true
		finishMission()
		trigger.active = false
	end
end,
tf_mission = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if Sectors.base.isDone then return end
		if 0 == getGVAR("isRT") then return end
		if ARMY ~= Sectors.base.owner then return end
		
		local result = checkRelations(PLAYER, ARMY)
		if ENEMY == result or isConflictStarted then
			startDlg("docu_check","army_1",CUR_MISSION.Mercs[1])
			changeLocalRelations(ENEMY, "army")
		else
			startDlg("docu_check","army_1",CUR_MISSION.Mercs[1])
		end				
		trigger.active = false
		return							
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,"mercs") ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, "army")		
			
--		changeLocalRelations(ALLY, "army")		
		trigger.active = false
	end
end,
tf_save_the_shammy = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false		
		storyline("shammy_is_ready_for_rescue")
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
